/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.nativesystem.NativeMethods;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCurrentUserIsDomainUser
extends Task {
    private String userName = System.getProperty("user.name");

    public TaskCurrentUserIsDomainUser(String[] nodeList) {
        super(nodeList, null, 1);
    }

    @Override
    public boolean performTask() {
        ErrorDescription errorDesc;
        String domainName = "";
        String errorMsg = "";
        String warningMsg = "";
        String localNodeName = null;
        boolean isNoDomainName = false;
        NativeResult result = new NativeResult();
        this.setSeverity(SeverityType.IGNORABLE);
        ReportUtil.blankln();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9996", false));
        ReportUtil.println(s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.userName}));
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            if (!VerificationUtil.isLocalNode(this.m_nodeList[i])) continue;
            localNodeName = this.m_nodeList[i];
            break;
        }
        if (localNodeName == null) {
            try {
                localNodeName = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                Trace.out((String)("Failed to retrieve LocalHost Name, ERROR :" + e.getMessage()));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
        }
        Result nodeRslt = null;
        if (localNodeName == null || localNodeName.trim().length() <= 0) {
            Trace.out((String)"Failed to retrieve LocalHost Name, hence quiting this check here.");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        nodeRslt = new Result(localNodeName);
        try {
            new NativeMethods().isUserDomainUser(result);
        }
        catch (NativeException e) {
            Trace.out((String)("TaskCurrentUserIsDomainUser:: Exception occured in calling isUserDomainUser() method" + (Object)((Object)e)));
        }
        if (!result.getStatus()) {
            Trace.out((String)"TaskCurrentUserIsDomainUser:: Execution was not successful");
            Trace.out((String)("TaskCurrentUserIsDomainUser:: OS Error code = " + result.getOSErrCode()));
            Trace.out((String)("TaskCurrentUserIsDomainUser:: OS Error message = " + result.getOSString()));
            errorMsg = s_msgBundle.getMessage("10000", true, (Object[])new String[]{this.userName, result.getOSString()});
            nodeRslt.setStatus(2);
            errorDesc = new ErrorDescription(errorMsg);
            nodeRslt.addErrorDescription(errorDesc);
        } else if (!result.getBooleanResult()) {
            Trace.out((String)"TaskCurrentUserIsDomainUser:: Execution was successful but result is false");
            if (result.getStringResult() != null && result.getStringResult().trim().length() > 0) {
                domainName = result.getStringResult().trim();
                Trace.out((String)("TaskCurrentUserIsDomainUser:: User '" + this.userName + "' is not a part of domain '" + domainName + "', Or Domain name could not be contacted"));
                warningMsg = s_msgBundle.getMessage("9998", true, (Object[])new String[]{this.userName, domainName});
            } else {
                Trace.out((String)("TaskCurrentUserIsDomainUser:: User '" + this.userName + "' is not a part of domain, The domain name could not be identified for this user"));
                warningMsg = s_gMsgBundle.getMessage("10510", true, (Object[])new String[]{this.userName});
                isNoDomainName = true;
            }
            nodeRslt.setStatus(4);
            errorDesc = new ErrorDescription(warningMsg);
            nodeRslt.addErrorDescription(errorDesc);
        } else {
            Trace.out((String)"TaskCurrentUserIsDomainUser:: Execution was successful and result is true");
            Trace.out((String)("TaskCurrentUserIsDomainUser:: Retrieved domain name is " + result.getStringResult()));
            domainName = result.getStringResult();
            nodeRslt.setStatus(1);
        }
        boolean ret = false;
        if (nodeRslt.getStatus() == 2) {
            ReportUtil.printResult(errorMsg);
        } else if (nodeRslt.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("9997", false, (Object[])new String[]{this.userName, domainName}));
            ret = true;
        } else if (nodeRslt.getStatus() == 4) {
            if (isNoDomainName) {
                ReportUtil.printWarning(s_gMsgBundle.getMessage("10510", false, (Object[])new String[]{this.userName}));
            } else {
                ReportUtil.printWarning(s_msgBundle.getMessage("9998", false, (Object[])new String[]{this.userName, domainName}));
            }
        }
        this.m_resultSet.addResult(localNodeName, nodeRslt);
        return ret;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.userName});
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.userName});
    }
}

